<?php

use Codexpert\CoDesigner\Helper;
use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Text_Stroke;

// Exit if accessed directly

if ( ! defined( 'ABSPATH' ) ) {
	exit; 
}

$widget         = $args['this'];
$placeholders   = [ '%%order_id%%', '%%user_name%%', '%%status%%', '%%date%%', '%%website_link%%', '%%order_notes%%' , '%%admin_name%%'];

$widget->start_controls_section(
    'order_cancelled_heading',
    [
        'label'      => __( 'Heading', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_CONTENT,
        'condition'  => [
            'cd_email_type' => 'admin-cancelled-order',
        ],
    ]
);

$widget->add_control(
    'cancelled_heading_important_note',
    [
        'label' => __( 'Important Note', 'codesigner-pro' ),
        'type' 	=> Controls_Manager::RAW_HTML,
        'raw' 	=> sprintf( __( 'You can use the placeholders. %s. This will replace with actual order data.', 'codesigner-pro' ), "<code>" . implode( '</code> <code>' ,$placeholders ) . "</code>" ),
        'content_classes' => 'elementor-panel-alert elementor-panel-alert-success',
    ]
);

$widget->add_control(
    'order_heading_txt_cancelled',
    [
        'label'         => __( 'Heading Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Order %%status%% #%%order_id%%', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
    ]
);

$widget->end_controls_section();

$widget->start_controls_section(
    'order_cancelled_body',
    [
        'label'      => __( 'Body', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_CONTENT,
        'condition'  => [
            'cd_email_type' => 'admin-cancelled-order',
        ],
    ]
);

$widget->add_control(
    'cancelled_body_important_note',
    [
        'label' => __( 'Important Note', 'codesigner-pro' ),
        'type' 	=> Controls_Manager::RAW_HTML,
        'raw' 	=> sprintf( __( 'You can use the placeholders. %s. This will replace with actual order data.', 'codesigner-pro' ), "<code>" . implode( '</code> <code>' ,$placeholders ) . "</code>" ),
        'content_classes' => 'elementor-panel-alert elementor-panel-alert-success',
    ]
);

$widget->add_control(
    'order_sub_txt_cancelled',
    [
        'label'         => __( 'Sub Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXTAREA,
        'rows'          => 5,
        'default'       => __( 'Notification to let you know -#%%order_id%% belonging to %%user_name%%  has been %%status%% ' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
    ]
);

$widget->add_control(
    'table_heading_txt_cancelled',
    [
        'label'         => __( 'Table Heading', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Order #%%order_id%% (%%date%%)' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
    ]
);

$widget->add_control(
    'product_billing_txt_cancelled',
    [
        'label'         => __( 'Billing Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Billing Address', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
    ]
);

$widget->add_control(
    'product_shipping_txt_cancelled',
    [
        'label'         => __( 'Shipping Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Shipping Address', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
    ]
);

$widget->add_control(
    'thanks_txt_cancelled',
    [
        'label'         => __( 'Thanks Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( 'Thanks for reading', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
    ]
);

$widget->end_controls_section();

$widget->start_controls_section(
    'order_cancelled_footer',
    [
        'label'      => __( 'Footer', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_CONTENT,
        'condition'  => [
            'cd_email_type' => 'admin-cancelled-order',
        ],
    ]
);

$widget->add_control(
    'cancelled_footer_important_note',
    [
        'label' => __( 'Important Note', 'codesigner-pro' ),
        'type' 	=> Controls_Manager::RAW_HTML,
        'raw' 	=> sprintf( __( 'You can use the placeholders. %s. This will replace with actual order data.', 'codesigner-pro' ), "<code>" . implode( '</code> <code>' ,$placeholders ) . "</code>" ),
        'content_classes' => 'elementor-panel-alert elementor-panel-alert-success',
    ]
);


$widget->add_control(
    'footer_cancelled_text',
    [
        'label'         => __( 'Footer Text', 'codesigner' ),
        'type'          => Controls_Manager::TEXT,
        'default'       => __( '%%website_link%% - Build with CoDesigner', 'codesigner' ),
        'placeholder'   => __( 'Type your title here', 'codesigner' ),
    ]
);

$widget->end_controls_section();

$widget->start_controls_section(
    'order_cancelled',
    [
        'label'      => __( 'Background', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_email_type' => 'admin-cancelled-order',
        ],
    ]
);

$widget->add_control(
    'order_bg_color_cancelled',
    [
        'label' 	=> esc_html__( 'Section Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-deafult-bg' => 'background: {{VALUE}} ',
            '{{WRAPPER}} .codesigner-email-wrapper' => 'background: {{VALUE}} ',
        ],
    ]
);

$widget->add_control(
    'order_bg_table_color_cancelled',
    [
        'label' 	=> esc_html__( 'Table Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .cd-email-center' => 'background: {{VALUE}} ',
            '{{WRAPPER}} table td' => 'background: {{VALUE}} ',
        ],
    ]
);

$widget->end_controls_section();

$widget->start_controls_section(
    'order_heading_cancelled',
    [
        'label'      => __( 'Table Heading', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_email_type' => 'admin-cancelled-order',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'table_heading_typography_cancelled',
        'selector'  => '{{WRAPPER}} #cd-admin-cancelled-order .codesigner-email-header h3',
    ]
);
$widget->add_control(
    'order_heading_bg_color_cancelled',
    [
        'label' 	=> esc_html__( 'Background Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-admin-cancelled-order .codesigner-email-header' => 'background: {{VALUE}} ',
        ],
    ]
);
$widget->add_control(
    'order_heading_color_cancelled',
    [
        'label' 	=> esc_html__( 'Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-admin-cancelled-order .codesigner-email-header h3' => 'color: {{VALUE}} ',
        ],
    ]
);
$widget->end_controls_section();

$widget->start_controls_section(
    'order_message_cancelled',
    [
        'label'      => __( 'Table Order Message', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_email_type' => 'admin-cancelled-order',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'table_order_message_typography_cancelled',
        'selector'  => '{{WRAPPER}} #cd-admin-cancelled-order .codesigner-order-cancelled-message p',
    ]
);
$widget->add_control(
    'table_order_message_text_color_cancelled',
    [
        'label' 	=> esc_html__( 'Text Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-admin-cancelled-order .codesigner-order-cancelled-message p' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->add_control(
    'table_order_message_border_color_cancelled',
    [
        'label' 	=> esc_html__( 'Border Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-admin-cancelled-order .codesigner-order-cancelled-message' => 'border-color: {{VALUE}}',
        ],
    ]
);
$widget->end_controls_section();

$widget->start_controls_section(
    'product_table_heading_cancelled',
    [
        'label'      => __( 'Product Table Heading', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_email_type' => 'admin-cancelled-order',
        ],
    ]
); 
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'product_table_heading_typography_cancelled',
        'selector'  => '{{WRAPPER}} #cd-admin-cancelled-order .codesigner-order-date h4',
    ]
);
$widget->add_control(
    'product_table_heading_color_cancelled',
    [
        'label' 	=> esc_html__( 'Text Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-admin-cancelled-order .codesigner-order-date h4' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->end_controls_section();

$widget->start_controls_section(
    'product_table_cancelled',
    [
        'label'      => __( 'Product Table', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_email_type' => 'admin-cancelled-order',
        ],
    ]
); 
$widget->start_controls_tabs(
    'product_table_section_cancelled'
);
$widget->start_controls_tab(
    'product_table_head_cancelled',
    [
        'label' => esc_html__( 'Header', 'codesigner-pro' ),
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'product_table_header_typography_cancelled',
        'selector'  => '{{WRAPPER}} #cd-admin-cancelled-order .codesigner-product-table th',
    ]
);
$widget->add_control(
    'product_table_header_color_cancelled',
    [
        'label' 	=> esc_html__( 'Text Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-admin-cancelled-order .codesigner-product-table th' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->add_control(
    'product_table_header_background_cancelled',
    [
        'label' 	=> esc_html__( 'Background', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-admin-cancelled-order .codesigner-product-table thead tr th' => 'background-color: {{VALUE}}',
        ],
    ]
);
$widget->end_controls_tab();

$widget->start_controls_tab(
    'product_table_products_cancelled',
    [
        'label' => esc_html__( 'Products', 'codesigner-pro' ),
    ]
);
$widget->add_responsive_control(
    'product_table_image_control_cancelled',
    [
        'type'   => Controls_Manager::SLIDER,
        'label'  => esc_html__( 'Image Sizing', 'codesigner-pro' ),
        'range'  => [
            'px' => [
                'min' => 0,
                'max' => 64,
            ],
        ],
        'devices'         => [ 'desktop', 'tablet', 'mobile' ],
        'desktop_default' => [
            'size' => 64,
            'unit' => 'px',
        ],
        'tablet_default' => [
            'size' => 48,
            'unit' => 'px',
        ],
        'mobile_default' => [
            'size' => 32,
            'unit' => 'px',
        ],
        'selectors' => [
            '{{WRAPPER}} #cd-admin-cancelled-order .codesigner-product-table tbody tr td img' => 'width: {{SIZE}}{{UNIT}};',
        ],
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'product_table_products_typography_cancelled',
        'selector'  => '{{WRAPPER}} #cd-admin-cancelled-order .codesigner-product-table tbody tr td span ,
                        {{WRAPPER}} #cd-admin-cancelled-order .codesigner-product-table tbody tr td',
    ]
);
$widget->add_control(
    'product_table_products_color_cancelled',
    [
        'label' 	=> esc_html__( 'Text Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-admin-cancelled-order .codesigner-product-table tbody tr td span' => 'color: {{VALUE}}',
            '{{WRAPPER}} #cd-admin-cancelled-order .codesigner-product-table tbody tr td' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->add_control(
    'product_table_products_background_cancelled',
    [
        'label' 	=> esc_html__( 'Background', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-admin-cancelled-order .codesigner-product-table tbody tr td'    => 'background-color: {{VALUE}}',
        ],
    ]
);
$widget->add_control(
    'product_table_products_border_color_cancelled',
    [
        'label' 	=> esc_html__( 'Border Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-admin-cancelled-order .codesigner-product-table tbody tr td'    => 'border-color : {{VALUE}}',
        ],
    ]
);
$widget->end_controls_tab();


$widget->start_controls_tab(
    'product_table_footer_cancelled',
    [
        'label' => esc_html__( 'Footer', 'codesigner-pro' ),
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'product_table_footer_typography_cancelled',
        'selector'  => '{{WRAPPER}} #cd-admin-cancelled-order .codesigner-item-price-table tbody tr td:last-child,
                        {{WRAPPER}} #cd-admin-cancelled-order .codesigner-item-price-table tbody tr td:first-child',
    ]
);
$widget->add_control(
    'product_table_footer_color_cancelled',
    [
        'label' 	=> esc_html__( 'Text Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-admin-cancelled-order .codesigner-item-price-table tbody tr td:last-child' => 'color: {{VALUE}}',
            '{{WRAPPER}} #cd-admin-cancelled-order .codesigner-item-price-table tbody tr td:first-child' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->add_control(
    'product_table_footer_border_color_cancelled',
    [
        'label' 	=> esc_html__( 'Border Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-admin-cancelled-order .codesigner-item-price-table tbody tr td' => 'border-color: {{VALUE}}',
        ],
    ]
);
$widget->end_controls_tab();

$widget->end_controls_tabs();
$widget->end_controls_section();

$widget->start_controls_section(
    'billing_and_shipping_address_cancelled',
    [
        'label'      => __( 'Billing & Shipping Address', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_email_type' => 'admin-cancelled-order',
        ],
    ]
); 
$widget->start_controls_tabs(
    'billing_and_shipping_table_section_cancelled'
);
$widget->start_controls_tab(
    'billing_shipping_table_header_cancelled',
    [
        'label' => esc_html__( 'Header', 'codesigner-pro' ),
    ]
);

$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'billing_shipping_header_typography_cancelled',
        'selector'  => '{{WRAPPER}} #cd-admin-cancelled-order .cd-shipping-billing-table thead tr th',
    ]
);
$widget->add_control(
    'billing_shipping_header_color_cancelled',
    [
        'label' 	=> esc_html__( 'Header Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-admin-cancelled-order .cd-shipping-billing-table thead tr th' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->end_controls_tab();
$widget->start_controls_tab(
    'billing_shipping_table_body_cancelled',
    [
        'label' => esc_html__( 'Body', 'codesigner-pro' ),
    ]
);
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'billing_shipping_body_typography_cancelled',
        'selector'  => '{{WRAPPER}} #cd-admin-cancelled-order .cd-shipping-billing-table tbody tr td',
    ]
);
$widget->add_control(
    'billing_shipping_body_color_cancelled',
    [
        'label' 	=> esc_html__( 'Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-admin-cancelled-order .cd-shipping-billing-table tbody tr td' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->add_control(
    'billing_shipping_header_background_cancelled',
    [
        'label' 	=> esc_html__( 'Background', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-admin-cancelled-order .cd-shipping-billing-table tbody tr td' => 'background: {{VALUE}}',
        ],
    ]
);
$widget->add_responsive_control(
    'billing_shipping_body_border_radius_cancelled',
    [
        'type'       => Controls_Manager::DIMENSIONS,
        'label'      => esc_html__( 'Border Radius', 'codesigner-pro' ),
        'size_units' => [ 'px', '%', 'em', 'rem', 'custom' ],
        'selectors'  => [
            '{{WRAPPER}} #cd-admin-cancelled-order .cd-shipping-billing-table tbody tr td' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$widget->end_controls_tab();
$widget->end_controls_tabs();
$widget->end_controls_section();

$widget->start_controls_section(
    'before_footer_msg_cancelled',
    [
        'label'      => __( 'Footer Message', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_email_type' => 'admin-cancelled-order',
        ],
    ]
); 
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'before_footer_msg_typography_cancelled',
        'selector'  => '{{WRAPPER}} #cd-admin-cancelled-order .cd-before-footer-message p ,
                        {{WRAPPER}} #cd-admin-cancelled-order .cd-before-footer-message p a',
    ]
);
$widget->add_control(
    'before_footer_msg_color_cancelled',
    [
        'label' 	=> esc_html__( 'Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-admin-cancelled-order .cd-before-footer-message p' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->end_controls_section();

$widget->start_controls_section(
    'footer_btn_cancelled',
    [
        'label'      => __( 'Footer Button', 'codesigner-pro' ),
        'tab'        => Controls_Manager::TAB_STYLE,
        'condition'  => [
            'cd_email_type' => 'admin-cancelled-order',
        ],
    ]
); 
$widget->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'footer_msg_typography_cancelled',
        'selector'  => '{{WRAPPER}} #cd-admin-cancelled-order .cd-link-area p',
    ]
);
$widget->add_control(
    'footer_msg_color_cancelled',
    [
        'label' 	=> esc_html__( 'Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-admin-cancelled-order .cd-link-area p' => 'color: {{VALUE}}',
            '{{WRAPPER}} #cd-admin-cancelled-order .cd-link-area p a' => 'color: {{VALUE}}',
        ],
    ]
);
$widget->add_control(
    'footer_msg_background_cancelled',
    [
        'label' 	=> esc_html__( 'Background Color', 'codesigner-pro' ),
        'type' 		=> Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} #cd-admin-cancelled-order .cd-link-area' => 'background-color: {{VALUE}}',
        ],
    ]
);
$widget->end_controls_section();